//
//  BIAbstractSlipWindow.h
//  BIViews
//
//  Created by Eric Hochmeister on 21/04/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <MCApplication/MCWindowController.h>

@class BITimeSlipType;
@class BIAbstractSlipSubcard;
@class BITimeSlip;

@interface BIAbstractSlipWindow : MCWindowController {

	id _parent;
	id _timeSlip;
	
	IBOutlet NSView* _slipSubview;
	IBOutlet NSPopUpButton* templatesPopUp;
	
	BIAbstractSlipSubcard* view;
	
	BOOL _createTimeSlipFlag;
	
	NSArray* _slipTypes;
    
    BOOL isEditable;
	
}

- (id)parent;
- (void)setParent:(id)aParent;
- (id)timeSlip;
- (void)setTimeSlip:(id)aTimeSlip;

- (NSArray *)slipTypes;
- (void)setSlipTypes:(NSArray *)aSlipTypes;

- (BOOL)createTimeSlipFlag;
- (void)setCreateTimeSlipFlag:(BOOL)flag;

- (void)loadSubcard;

- (IBAction)applySlipTemplate:(id)sender;

// Notifications

// [aNotif object] is the slip template which was added
- (void)handleSlipTemplateAddedNotification:(NSNotification*)aNotif;

// [aNotif object] is the slip templates which were deleted
- (void)handleSlipTemplateDeletedNotification:(NSNotification*)aNotif;

- (void)refreshSlipTemplatesMenu;

- (IBAction)createTemplateFromSlip:(id)sender;

- (void)createSlipTemplateFromSlipSheetDidEnd:(NSWindow*)sheet
                                   returnCode:(int)returnCode
                                  contextInfo:(void*)contextInfo;

- (BOOL)isEditable;
- (void)setIsEditable:(BOOL)aFlag;

@end
